////////////////////////////////////////////////////////////////////////////////
//                                                                            //
// evaltables.cpp                                                             //
//                                                                            //
// Copyright Matthew Gingell <gingell@adacore.com>, 2009. Chesley the         //
// Chess Engine! is free software distributed under the terms of the          //
// GNU Public License.                                                        //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include <iostream>

#include "chesley.hpp"

using namespace std;

//////////////////////////////////////////////////////////////////////
//                                                                  //
// centrality_table:                                                //
//                                                                  //
// This is a table reflects the relative value of locations on the  //
// chess board based on their proximity to the center.              //
//                                                                  //
//////////////////////////////////////////////////////////////////////

const int8 Eval::centrality_table[64] =
  {
   1, 1, 1, 1, 1, 1, 1, 1,
   1, 2, 2, 2, 2, 2, 2, 1,
   1, 2, 4, 4, 4, 4, 2, 1,
   1, 2, 4, 8, 8, 4, 2, 1,
   1, 2, 4, 8, 8, 4, 2, 1,
   1, 2, 4, 4, 4, 4, 2, 1,
   1, 2, 2, 2, 2, 2, 2, 1,
   1, 1, 1, 1, 1, 1, 1, 1
  };

/////////////////////////////////////////////////////////////////////////
//                                                                     //
//  piece_square_table:                                                //
//                                                                     //
//  This is a table of bonuses for each piece-location pair. The table //
//  is written in 'reverse' for readability and a transformation is    //
//  required for fetching values for black and white.                  //
//                                                                     //
/////////////////////////////////////////////////////////////////////////

const int8 Eval::xfrm[2][64] = 
{
  // Transformation for white.
  {
    56,  57,  58,  59,  60,  61,  62,  63,
    48,  49,  50,  51,  52,  53,  54,  55,
    40,  41,  42,  43,  44,  45,  46,  47,
    32,  33,  34,  35,  36,  37,  38,  39,
    24,  25,  26,  27,  28,  29,  30,  31,
    16,  17,  18,  19,  20,  21,  22,  23,
     8,   9,  10,  11,  12,  13,  14,  15,
     0,   1,   2,   3,   4,   5,   6,   7
  },

  // Transformation for black.
  {
     0,   1,   2,   3,   4,   5,   6,   7,
     8,   9,  10,  11,  12,  13,  14,  15,
    16,  17,  18,  19,  20,  21,  22,  23,
    24,  25,  26,  27,  28,  29,  30,  31,
    32,  33,  34,  35,  36,  37,  38,  39,
    40,  41,  42,  43,  44,  45,  46,  47,
    48,  49,  50,  51,  52,  53,  54,  55,
    56,  57,  58,  59,  60,  61,  62,  63,
  }
};

const int8 Eval::piece_square_table[6][64] =
{
  // Pawns
  {
     0,   0,   0,   0,   0,   0,   0,   0,
    70,  70,  70,  70,  70,  70,  70,  70,
    10,  10,  20,  30,  30,  20,  10,  10,
     5,   5,  10,  16,  16,  10,   5,   5,
     3,   3,   3,  13,  13,   3,   3,   3,
     1,   1,   1,  10,  10,   1,   1,   1,
     0,   0,   0, -25, -25,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0
  },

  // Rooks
  {
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0,
     0,   0,   0,   0,   0,   0,   0,   0
  },

  // Knights
  {
   -50, -40, -30, -30, -30, -30, -40, -50,
   -40, -20,   0,   0,   0,   0, -20, -40,
   -30,   0,  10,  15,  15,  10,   0, -30,
   -30,   5,  15,  20,  20,  15,   5, -30,
   -30,   0,  15,  20,  20,  15,   0, -30,
   -30,   5,  10,  15,  15,  10,   5, -30,
   -40, -20,   0,   5,   5,   0, -20, -40,
   -50, -40, -30, -30, -30, -30, -40, -50
  },

  // Bishops
  {
   -20, -10, -10, -10, -10, -10, -10, -20,
   -10,   0,   0,   0,   0,   0,   0, -10,
   -10,   0,   5,  10,  10,   5,   0, -10,
   -10,   5,   5,  10,  10,   5,   5, -10,
   -10,   0,  10,  10,  10,  10,   0, -10,
   -10,  10,  10,  10,  10,  10,  10, -10,
   -10,   5,   0,   0,   0,   0,   5, -10,
   -20, -10, -10, -10, -10, -10, -10, -20
  },

  // Queens
  {
   -20, -10, -10,  -5, -5, -10, -10, -20,
   -10,   0,   0,   0,  0,   0,   0, -10,
   -10,   0,   5,   5,  5,   5,   0, -10,
    -5,   0,   5,   5,  5,   5,   0,  -5,
     0,   0,   5,   5,  5,   5,   0,  -5,
   -10,   0,   5,   5,  5,   5,   0, -10,
   -10,   0,   0,   0,  0,   0,   0, -10,
   -20, -10, -10,  -5, -5, -10, -10, -20
  }
};

const int8 
Eval::king_square_table[3][64] =
{
  // Kings in the opening.
  {
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -20, -20, -20, -20, -20, -20, -20, -20,
     0,  20,  40, -20,   0, -20,  40,  20
  },

  // Kings in the midgame.
  {
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -40, -40, -40, -40, -40, -40, -40, -40,
   -20, -20, -20, -20, -20, -20, -20, -20,
     0,  20,  40, -20,   0, -20,  40,  20
  },

  // Kings in the endgame.
  {
     0,  10,  20,  30,  30,  20,  10,   0,
    10,  20,  30,  40,  40,  30,  20,  10,
    20,  30,  40,  50,  50,  40,  30,  20,
    30,  40,  50,  60,  60,  50,  40,  30,
    30,  40,  50,  60,  60,  50,  40,  30,
    20,  30,  40,  50,  50,  40,  30,  20,
    10,  20,  30,  40,  40,  30,  20,  10,
     0,  10,  20,  30,  30,  20,  10,   0
  }
};
